﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using System.ComponentModel.DataAnnotations;
using BMS.Web.Controllers.Shared;
using BMS.Utils;
using BMS.Web.App_GlobalResource;

namespace BMS.Web.Models
{
    public class IconLibraryViewModel : BaseViewModel
    {
        List<IconInfo> _siteIconList;

        public List<IconInfo> SiteConfigurableIcons 
        {
            get { return _siteIconList; }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    _siteIconList = value;
                    SiteConfigurableIconList = new List<IconInfoExtended>();                   
                    if (_siteIconList != null)
                    {
                        for (int i = 0; i < _siteIconList.Count; i++)
                            SiteConfigurableIconList.Add(new IconInfoExtended() { Icon = _siteIconList[i], OrderIndexView = i + 1 });                        
                    }                    
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        public List<IconInfoExtended> SiteConfigurableIconList { get; set; }

        public IconInfo PatientIcon { get; set; }

        public IconInfo RoomBedIcon { get; set; }

        public List<IconDetail> AutoIcons { get; set; }

        public bool Active { get; set; }

        public bool Test { get { return true; } }

        public string ImageBytes { get; set; }

        public string ImageBytesInactive { get; set; }

        public string ImageName { get; set; }

        public string IconNameTitle { get; set; }

        public string IconShortDescription { get; set; }

        [RequiredIf("Active", "True", ErrorMessage = "The Facility Icon Name field is required!")]
        [ValidateXss]
        public string IconName { get; set; }

        [RequiredIf("Active", "True", ErrorMessage = "The Facility Icon Description field is required!")]
        [ValidateXss]
        public string IconDescription { get; set; }

        [StringLength(Constants.COMMENTS_MAX_LENGTH, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "FacilityCommentLengthError")]
        [ValidateXss]
        public string Comment { get; set; }

        [RequiredIf("Active", "True", ErrorMessage = "The Facility Mouse Over Text field is required!")]
        [ValidateXss]
        public string MouseOverText { get; set; }

        public bool AutoIconActive { get; set; }

        public bool IsIsolation { get; set; }

        public bool PatientOrRoomBed { get; set; }

        public int IconId { get; set; }

        public int OrderIndex { get; set; }      

        public string ButtonSave { get; set; }

        public string ButtonReset { get; set; }

        public bool IsIconAssociated { get; set; }

        public int SwitchIconId1 { get; set; }

        public int SwitchIconId2 { get; set; }
    }

    public class IconInfoExtended
    {
        public IconInfo Icon { get; set; }

        public int OrderIndexView { get; set; }
    }
}